import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)
  const id = getRouterParam(event, 'id')

  const res: any = await fetchHelper(event, `models/c_channel/${id}/attachments`, 'POST', token, {
    name: body.name,
    data: body.data
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = {
        status: error.status || error.statusCode || 500,
        message: error.detail || error.message || error.statusMessage
      }
      //if(data.status < 500) {
        //@ts-ignore
        //setCookie(event, 'user', null)
      //}
    }
  }

  return data
})